<?php
session_start();
if(!isset($_SESSION['admin_logged_in'])){
    header("Location: login.php");
    exit;
}

include "db.php";

/* DELETE */
if(isset($_GET['del'])){
    $id = $_GET['del'];
    $old = mysqli_fetch_assoc(mysqli_query($conn,"SELECT logo FROM site_settings WHERE id='$id'"));
    if(!empty($old['logo']) && file_exists("uploads/".$old['logo'])){
        unlink("uploads/".$old['logo']);
    }
    mysqli_query($conn,"DELETE FROM site_settings WHERE id='$id'");
    header("Location: admin-site-settings.php");
    exit;
}

/* EDIT FETCH */
$edit_id = $_GET['edit'] ?? '';
$editData = [];
if($edit_id){
    $editData = mysqli_fetch_assoc(mysqli_query($conn,"SELECT * FROM site_settings WHERE id='$edit_id'"));
}

/* ADD / UPDATE */
if(isset($_POST['submit'])){
    $address = mysqli_real_escape_string($conn,$_POST['address']);
    $phone   = mysqli_real_escape_string($conn,$_POST['phone']);
    $email   = mysqli_real_escape_string($conn,$_POST['email']);
    $enquiry_email = mysqli_real_escape_string($conn,$_POST['enquiry_email']);
    $location_map  = mysqli_real_escape_string($conn,$_POST['location_map']);

    $facebook  = mysqli_real_escape_string($conn,$_POST['facebook']);
    $twitter   = mysqli_real_escape_string($conn,$_POST['twitter']);
    $instagram = mysqli_real_escape_string($conn,$_POST['instagram']);
    $linkedin  = mysqli_real_escape_string($conn,$_POST['linkedin']);

    if(!empty($_FILES['logo']['name'])){
        $logo = time().'_'.$_FILES['logo']['name'];
        move_uploaded_file($_FILES['logo']['tmp_name'], "uploads/".$logo);
    } else {
        $logo = $editData['logo'] ?? '';
    }

    if($edit_id){
        mysqli_query($conn,"UPDATE site_settings SET 
            logo='$logo',
            address='$address',
            phone='$phone',
            email='$email',
            enquiry_email='$enquiry_email',
            location_map='$location_map',
            facebook='$facebook',
            twitter='$twitter',
            instagram='$instagram',
            linkedin='$linkedin'
        WHERE id='$edit_id'");
    } else {
        mysqli_query($conn,"INSERT INTO site_settings 
        (logo,address,phone,email,enquiry_email,location_map,facebook,twitter,instagram,linkedin) 
        VALUES 
        ('$logo','$address','$phone','$email','$enquiry_email','$location_map',
         '$facebook','$twitter','$instagram','$linkedin')");
    }

    header("Location: admin-site-settings.php");
    exit;
}

/* FETCH ALL */
$data = mysqli_query($conn,"SELECT * FROM site_settings ORDER BY id DESC");
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Site Settings</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<?php include "sidebar.php"; ?>

<div class="container mt-4">
<h2>Site Settings</h2>

<!-- FORM -->
<form method="POST" enctype="multipart/form-data" class="card p-3 mb-4">
<div class="row">

<div class="col-md-4 mb-3">
<label>Logo</label>
<input type="file" name="logo" class="form-control">
<?php if(!empty($editData['logo'])){ ?>
<img src="uploads/<?= $editData['logo'] ?>" width="100" class="mt-2">
<?php } ?>
</div>

<div class="col-md-4 mb-3">
<label>Address</label>
<input type="text" name="address" class="form-control" value="<?= $editData['address'] ?? '' ?>">
</div>

<div class="col-md-4 mb-3">
<label>Phone</label>
<input type="text" name="phone" class="form-control" value="<?= $editData['phone'] ?? '' ?>">
</div>

<div class="col-md-4 mb-3">
<label>Email</label>
<input type="email" name="email" class="form-control" value="<?= $editData['email'] ?? '' ?>">
</div>

<div class="col-md-4 mb-3">
<label>Enquiry Email</label>
<input type="email" name="enquiry_email" class="form-control" value="<?= $editData['enquiry_email'] ?? '' ?>">
</div>

<div class="col-md-12 mb-3">
<label>Location Map</label>
<textarea name="location_map" class="form-control"><?= $editData['location_map'] ?? '' ?></textarea>
</div>

<hr>

<div class="col-md-3 mb-3">
<label>Facebook URL</label>
<input type="url" name="facebook" class="form-control" value="<?= $editData['facebook'] ?? '' ?>">
</div>

<div class="col-md-3 mb-3">
<label>Twitter URL</label>
<input type="url" name="twitter" class="form-control" value="<?= $editData['twitter'] ?? '' ?>">
</div>

<div class="col-md-3 mb-3">
<label>Instagram URL</label>
<input type="url" name="instagram" class="form-control" value="<?= $editData['instagram'] ?? '' ?>">
</div>

<div class="col-md-3 mb-3">
<label>LinkedIn URL</label>
<input type="url" name="linkedin" class="form-control" value="<?= $editData['linkedin'] ?? '' ?>">
</div>

</div>

<button name="submit" class="btn btn-primary">
<?= $edit_id ? "Update Settings" : "Add Settings" ?>
</button>

<?php if($edit_id){ ?>
<a href="admin-site-settings.php" class="btn btn-secondary">Cancel</a>
<?php } ?>
</form>

<!-- TABLE -->
<table class="table table-bordered table-striped">
<thead>
<tr>
<th>ID</th>
<th>Logo</th>
<th>Address</th>
<th>Phone</th>
<th>Email</th>
<th>Enquiry Email</th>
<th>Map</th>
<th>Social</th>
<th>Action</th>
</tr>
</thead>

<tbody>
<?php while($r=mysqli_fetch_assoc($data)){ ?>
<tr>
<td><?= $r['id'] ?></td>

<td><?php if($r['logo']){ ?><img src="uploads/<?= $r['logo'] ?>" width="60"><?php } ?></td>
<td><?= htmlspecialchars($r['address']) ?></td>
<td><?= htmlspecialchars($r['phone']) ?></td>
<td><?= htmlspecialchars($r['email']) ?></td>
<td><?= htmlspecialchars($r['enquiry_email']) ?></td>

<td>
<?php if($r['location_map']){ ?>
<a href="<?= $r['location_map'] ?>" target="_blank">Map</a>
<?php } ?>
</td>

<td>
<?= $r['facebook'] ? 'FB ' : '' ?>
<?= $r['twitter'] ? 'TW ' : '' ?>
<?= $r['instagram'] ? 'IG ' : '' ?>
<?= $r['linkedin'] ? 'IN ' : '' ?>
</td>

<td>
<a href="?edit=<?= $r['id'] ?>" class="btn btn-warning btn-sm">Edit</a>
<a href="?del=<?= $r['id'] ?>" onclick="return confirm('Delete this setting?')" class="btn btn-danger btn-sm">Delete</a>
</td>
</tr>
<?php } ?>
</tbody>
</table>

</div>
</body>
</html>
