<?php
session_start();

/* LOGIN CHECK */
if(!isset($_SESSION['admin_logged_in'])){
    header("Location: login.php");
    exit;
}

/* DB */
$conn = mysqli_connect("localhost","root","","ecommerce");
if(!$conn){ die("DB Error"); }

/* COUNTS */
$total_products = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(*) AS cnt FROM products"))['cnt'];
$total_brands = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(*) AS cnt FROM masters WHERE type='brand'"))['cnt'];
$total_categories = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(*) AS cnt FROM masters WHERE type='category'"))['cnt'];
$total_detection = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(*) AS cnt FROM masters WHERE type='detection'"))['cnt'];
$total_tags = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(*) AS cnt FROM masters WHERE type='tag'"))['cnt'];
$total_sliders = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(*) AS cnt FROM sliders"))['cnt'];
$total_settings = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(*) AS cnt FROM site_settings"))['cnt'];

$username = $_SESSION['admin_username'] ?? 'Admin';
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Admin Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<style>
body{background:#f4f6f9;}
.sidebar{
    width:240px;
    min-height:100vh;
    background:#212529;
}
.sidebar a{
    color:#fff;
    padding:10px;
    display:block;
    text-decoration:none;
}
.sidebar a:hover{
    background:#0d6efd;
}
.card-box{
    border-radius:12px;
    color:#fff;
    padding:20px;
}
.bg1{background:#6f42c1;}
.bg2{background:#198754;}
.bg3{background:#fd7e14;}
.bg4{background:#dc3545;}
.bg5{background:#0dcaf0;}
.bg6{background:#0d6efd;}
</style>
</head>

<body>
<div class="d-flex">

<!-- SIDEBAR -->
<div class="sidebar">
    <h4 class="text-center py-3">ADMIN</h4>
    <a href="dashboard.php"><i class="fa fa-home"></i> Dashboard</a>
    <a href="admin-categories.php"><i class="fa fa-list"></i> Categories</a>
    <a href="admin-brands.php"><i class="fa fa-copyright"></i> Brands</a>
    <a href="admin-detection.php"><i class="fa fa-satellite-dish"></i> Detection</a>
    <a href="admin-tags.php"><i class="fa fa-tags"></i> Tags</a>
    <a href="admin-products.php"><i class="fa fa-box"></i> Products</a>
    <a href="admin-sliders.php"><i class="fa fa-images"></i> Sliders</a>
    <a href="admin-site-settings.php"><i class="fa fa-gear"></i> Site Settings</a>

    <a href="logout.php"><i class="fa fa-sign-out"></i> Logout</a>
</div>

<!-- CONTENT -->
<div class="flex-fill p-4">

<h3>Welcome, <?= htmlspecialchars($username) ?> 👋</h3>

<div class="row g-3 mt-3">

<div class="col-md-3">
<div class="card-box bg1">
<h6>Products</h6>
<h2><?= $total_products ?></h2>
<a href="admin-products.php" class="btn btn-light btn-sm">Manage</a>
</div>
</div>

<div class="col-md-3">
<div class="card-box bg2">
<h6>Brands</h6>
<h2><?= $total_brands ?></h2>
<a href="admin-brands.php" class="btn btn-light btn-sm">Manage</a>
</div>
</div>

<div class="col-md-3">
<div class="card-box bg3">
<h6>Categories</h6>
<h2><?= $total_categories ?></h2>
<a href="admin-categories.php" class="btn btn-light btn-sm">Manage</a>
</div>
</div>

<div class="col-md-3">
<div class="card-box bg4">
<h6>Detection</h6>
<h2><?= $total_detection ?></h2>
<a href="admin-detection.php" class="btn btn-light btn-sm">Manage</a>
</div>
</div>

<div class="col-md-3">
<div class="card-box bg5">
<h6>Tags</h6>
<h2><?= $total_tags ?></h2>
<a href="admin-tags.php" class="btn btn-light btn-sm">Manage</a>
</div>
</div>

<div class="col-md-3">
<div class="card-box bg6">
<h6>Sliders</h6>
<h2><?= $total_sliders ?></h2>
<a href="admin-sliders.php" class="btn btn-light btn-sm">Manage</a>
</div>
</div>
<div class="col-md-3">
<div class="card-box bg1">
<h6>Site Settings</h6>
<h2><?= $total_settings ?></h2>
<a href="admin-site-settings.php" class="btn btn-light btn-sm">Manage</a>
</div>
</div>
<hr class="my-4">

<div class="row">
    <div class="col-lg-12">
        <div class="card shadow-sm">
            <div class="card-header bg-white fw-bold">
                <i class="fa fa-chart-column text-primary"></i> System Overview
            </div>
            <div class="card-body">
                <canvas id="dashboardChart" height="120"></canvas>
            </div>
        </div>
    </div>
</div>

</div>
</div>
</div>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
const ctx = document.getElementById('dashboardChart');

new Chart(ctx, {
    type: 'bar',
    data: {
        labels: ['Products', 'Brands', 'Categories', 'Detection', 'Tags', 'Sliders', 'Settings'],
        datasets: [{
            label: 'Total Records',
            data: [
                <?= $total_products ?>,
                <?= $total_brands ?>,
                <?= $total_categories ?>,
                <?= $total_detection ?>,
                <?= $total_tags ?>,
                <?= $total_sliders ?>,
                <?= $total_settings ?>
            ],
            backgroundColor: [
                '#0d6efd',
                '#198754',
                '#fd7e14',
                '#dc3545',
                '#6f42c1',
                '#0dcaf0',
                '#adb5bd'
            ],
            borderRadius: 6,
            barThickness: 40
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            },
            tooltip: {
                backgroundColor: '#212529',
                titleColor: '#fff',
                bodyColor: '#fff',
                padding: 10
            }
        },
        scales: {
            x: {
                grid: { display: false }
            },
            y: {
                beginAtZero: true,
                ticks: {
                    stepSize: 1
                }
            }
        }
    }
});
</script>


</body>
</html>
