<?php
include "includes/header.php";
include "includes/db.php";

$category = $_GET['category'] ?? '';

if($category == ''){
    echo "<div class='container mt-5 alert alert-danger'>No category selected</div>";
    exit;
}

$category = mysqli_real_escape_string($conn, $category);

$products = mysqli_query($conn, "
    SELECT * FROM products 
    WHERE FIND_IN_SET('$category', REPLACE(categories,'|',','))
    ORDER BY position ASC
");
?>

<style>
body{ background:#f8f9fa; }

.page-title{
    background:#0d6efd;
    color:white;
    padding:30px 0;
    margin-bottom:30px;
}

.product-card{
    border:none;
    border-radius:12px;
    box-shadow:0 2px 10px rgba(0,0,0,0.08);
    transition:.3s;
}
.product-card:hover{
    transform:translateY(-5px);
    box-shadow:0 6px 15px rgba(0,0,0,0.15);
}
.product-card img{
    height:200px;
    object-fit:contain;
    padding:15px;
}
.price{
    font-weight:bold;
    color:#198754;
}
</style>

<!-- CATEGORY HEADER -->
<div class="page-title text-center">
    <h1>Category: <?= htmlspecialchars($category) ?></h1>
</div>

<div class="container">
<div class="row g-4">

<?php if(mysqli_num_rows($products) == 0){ ?>
    <div class="col-12">
        <div class="alert alert-warning text-center">
            No products found in this category.
        </div>
    </div>
<?php } ?>

<?php while($p = mysqli_fetch_assoc($products)){ ?>
<div class="col-lg-3 col-md-4 col-sm-6">
    <div class="card product-card h-100">

        <img src="uploads/products/<?= $p['main_image'] ?>" 
             class="card-img-top" 
             alt="<?= $p['product_name'] ?>">

        <div class="card-body text-center d-flex flex-column">
            <h6 class="card-title"><?= $p['product_name'] ?></h6>
            <p class="price mb-2">₹ <?= number_format($p['price'],2) ?></p>

            <a href="product-details.php?id=<?= $p['id'] ?>" 
               class="btn btn-primary btn-sm mt-auto">
                View Product
            </a>
        </div>

    </div>
</div>
<?php } ?>

</div>
</div>

<?php include "includes/footer.php"; ?>
