<?php 
include 'includes/header.php';
include 'includes/db.php';

$settings = mysqli_fetch_assoc(mysqli_query($conn,"SELECT * FROM site_settings ORDER BY id DESC LIMIT 1"));
?>


<section class="contact-style-2 py-5">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="contact2-title text-center mb-65">
                    <h2>contact us</h2>
                   
                </div>
            </div>
        </div>

        <div class="row">
            <!-- ADDRESS -->
            <div class="col-lg-4 col-md-6 col-sm-6">
                <div class="contact-single-info mb-30 text-center">
                    <div class="contact-icon">
                        <i class="fa fa-map-marker"></i>
                    </div>
                    <h3>address</h3>
                    <p><?= nl2br(htmlspecialchars($settings['address'])) ?></p>
                </div>
            </div>

            <!-- PHONE -->
            <div class="col-lg-4 col-md-6 col-sm-6">
                <div class="contact-single-info mb-30 text-center">
                    <div class="contact-icon">
                        <i class="fa fa-phone"></i>
                    </div>
                    <h3>phone</h3>
                    <p><?= htmlspecialchars($settings['phone']) ?></p>
                </div>
            </div>

            <!-- EMAIL -->
            <div class="col-lg-4 col-md-6 col-sm-6">
                <div class="contact-single-info mb-30 text-center">
                    <div class="contact-icon">
                        <i class="fa fa-envelope"></i>
                    </div>
                    <h3>email</h3>
                    <p><?= htmlspecialchars($settings['email']) ?></p>
                </div>
            </div>
        </div>
    </div>
</section>


<div class="contact-two-area py-5">
   <div class="container-fluid pb-5">

        <div class="row">
            <div class="col-12">
                <div class="contact2-title text-center mb-60">
                    <h2>tell us your project</h2>
                </div>
            </div>
        </div>

        <div class="row align-items-stretch">

            <!-- LEFT : CONTACT FORM -->
            <div class="col-lg-6 col-md-12">
                <div class="contact-message">
                    <form id="contact-form" method="post">

                        <div class="row">
                            <div class="col-md-6">
                                <input name="name" placeholder="Name *" type="text">    
                            </div>

                            <div class="col-md-6">
                                <input name="phone" placeholder="Phone *" type="text">   
                            </div>

                            <div class="col-md-6">
                                <input name="email" placeholder="Email *" type="text">    
                            </div>

                            <div class="col-md-6">
                                <input name="subject" placeholder="Subject *" type="text" required>
                            </div>

                            <div class="col-12">
                                <textarea placeholder="Message *" name="message" class="form-control2" required></textarea>     
                            </div>   

                            <div class="col-12 text-center mt-3">
                                <button class="krb-btn" type="submit">Send Message</button> 
                            </div> 
                        </div>

                    </form>    
                </div> 
           </div>

            <!-- RIGHT : LOCATION MAP -->
            <div class="col-lg-6 col-md-12">
          <div class="contact-map h-100">
    <?= $settings['location_map']; ?>
</div>

            </div>

       </div>

   </div>
</div>



<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.getElementById("contact-form").addEventListener("submit", function(e){
    e.preventDefault();

    let formData = new FormData(this);

    fetch("contact-process.php", {
        method: "POST",
        body: formData
    })
    .then(res => res.json())   // ✅ parse JSON
    .then(data => {
        if(data.status === "success"){
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: 'Successfully submitted',
                confirmButtonColor: '#28a745'
            });
            document.getElementById("contact-form").reset();
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: data.message,
                confirmButtonColor: '#dc3545'
            });
        }
    })
    .catch(err => {
        console.error(err);
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'Something went wrong!',
            confirmButtonColor: '#dc3545'
        });
    });
});
</script>



<?php include 'includes/footer.php'; ?>
