<?php 
include 'includes/header.php';

$conn = mysqli_connect("localhost","root","","ecommerce");
if(!$conn){ die("DB Error"); }

$id = $_GET['id'] ?? 1;

$product = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM products WHERE id='$id'"));
$gallery = array_filter(explode('|', $product['gallery_images']));

$pdfs = explode('|',$product['pdf_files']);
?>

<div class="container mt-5">

    <!-- BREADCRUMB -->
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb bg-light p-2 rounded">
        <li class="breadcrumb-item"><a href="products.php">Products /</a></li>
        <li class="breadcrumb-item active" aria-current="page"><?= $product['product_name'] ?></li>
      </ol>
    </nav>

    <div class="row mt-4">

        <!-- LEFT IMAGES -->
  <!-- LEFT IMAGES -->
<div class="col-lg-6">
    <div class="border p-2 mb-3">
        <img id="mainProductImage" src="uploads/products/<?= $product['main_image'] ?>" class="img-fluid rounded" alt="<?= $product['product_name'] ?>">
    </div>

    <?php if(!empty($product['main_image']) || count($gallery) > 0){ ?>
<div class="d-flex flex-wrap gap-2">

    <!-- MAIN IMAGE AS FIRST THUMB -->
    <?php if(!empty($product['main_image'])){ ?>
        <img src="uploads/products/<?= $product['main_image'] ?>" 
             class="img-thumbnail gallery-thumb border border-primary" 
             style="width:80px; height:80px; object-fit:cover; cursor:pointer;" 
             data-src="uploads/products/<?= $product['main_image'] ?>">
    <?php } ?>

    <!-- GALLERY IMAGES -->
    <?php foreach($gallery as $img){ ?>
        <img src="uploads/products/<?= $img ?>" 
             class="img-thumbnail gallery-thumb" 
             style="width:80px; height:80px; object-fit:cover; cursor:pointer;" 
             data-src="uploads/products/<?= $img ?>">
    <?php } ?>

</div>
<?php } ?>

</div>

<script>
document.addEventListener("DOMContentLoaded", function () {

    const mainImg = document.getElementById('mainProductImage');
    const thumbs = document.querySelectorAll('.gallery-thumb');

    thumbs.forEach(img => {
        img.addEventListener('click', () => {
            mainImg.src = img.getAttribute('data-src');

            thumbs.forEach(t => t.classList.remove('border', 'border-primary'));
            img.classList.add('border', 'border-primary');
        });
    });

});
</script>



        <!-- RIGHT INFO -->
        <div class="col-lg-6">
            <h2 class="fw-bold"><?= $product['product_name'] ?></h2>
            <p class="mb-1"><strong>Brand:</strong> <?= $product['brand'] ?></p>
            <p class="mb-1"><strong>Categories:</strong> <?= str_replace('|',' | ',$product['categories']) ?></p>
            <p class="mb-1"><strong>Detection Systems:</strong> <?= str_replace('|',' | ',$product['detection_systems']) ?></p>

            <div class="my-3">
                <p class="mb-1"><i class="bi bi-telephone"></i> +90 (216) 415 56 86</p>
                <p class="mb-1"><i class="bi bi-envelope"></i> info@noktadetectors.com</p>
            </div>

            <h3 class="text-success fw-bold">₹ <?= number_format($product['price'],2) ?></h3>
            <a href="checkout.php?product_id=<?= $id ?>" class="btn btn-success btn-lg mb-3">Buy Now</a>

            <p><?= $product['short_desc'] ?></p>
        </div>

    </div>

    <hr>

    <!-- PRODUCT DETAILS -->
 <hr>

<div class="row mt-4">
<div class="col-lg-12">

<ul class="nav nav-tabs" role="tablist">
  <li class="nav-item">
    <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#desc">Description</button>
  </li>

  <?php if($product['youtube_video']!=''){ ?>
  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#video">Video</button>
  </li>
  <?php } ?>

  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#features">Features</button>
  </li>

  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#package">Package Content</button>
  </li>

  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#specs">Specifications</button>
  </li>

  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#info">Informations</button>
  </li>

  <?php if(count($pdfs)>0){ ?>
  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#downloads">Downloads</button>
  </li>
  <?php } ?>

  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#faq">FAQ</button>
  </li>
</ul>

<div class="tab-content p-4 border border-top-0">

<!-- DESCRIPTION (IMAGES + HTML OK) -->
<div class="tab-pane fade show active" id="desc">
    <div class="ck-content">
        <?= $product['description'] ?>
    </div>
</div>


  <!-- VIDEO -->
  <?php if($product['youtube_video']!=''){ ?>
  <div class="tab-pane fade" id="video">
    <div class="ratio ratio-16x9">
      <iframe src="https://www.youtube.com/embed/<?= $product['youtube_video'] ?>" allowfullscreen></iframe>
    </div>
  </div>
  <?php } ?>

  <!-- FEATURES -->
<div class="tab-pane fade" id="features">
    <div class="ck-content">
        <?= $product['features'] ?>
    </div>
</div>

  <!-- PACKAGE CONTENT -->
 <div class="tab-pane fade" id="package">
    <div class="ck-content">
        <?= $product['package_content'] ?>
    </div>
</div>
  <!-- SPECIFICATIONS -->
  <div class="tab-pane fade" id="specs">
    <div class="ck-content">
        <?= $product['specifications'] ?>
    </div>
</div>

  <!-- INFORMATIONS -->
  <div class="tab-pane fade" id="info">
    <div class="ck-content">
        <?= $product['informations'] ?>
    </div>
</div>

  <!-- DOWNLOADS -->
 <?php if(count($pdfs) > 0){ ?>
<div class="tab-pane fade" id="downloads">
    <div class="row">

        <?php foreach($pdfs as $pdf){ ?>
        <div class="col-md-3 col-sm-4 col-6 mb-3 text-center">

           <a href="uploads/pdfs/<?= $pdf ?>" 
   download 
   target="_blank"
   class="btn w-100 py-3 pdf-btn">

    <div>
        <i class="fa fa-file-pdf fa-3x mb-2"></i>
    </div>

    <div>
        <i class="fa fa-download me-1"></i>
        Download
    </div>
</a>


        </div>
        <?php } ?>

    </div>
</div>
<?php } ?>



  <!-- FAQ -->
<div class="tab-pane fade" id="faq">
    <div class="ck-content">
        <?= $product['faq'] ?>
    </div>
</div>

</div>
</div>
</div>


    <!-- RELATED PRODUCTS -->
    <div class="mt-5">
        <h4 class="fw-bold mb-3">Related Products (Same Brand)</h4>
        <div class="row">
            <?php
            $related = mysqli_query($conn, "SELECT * FROM products WHERE brand='{$product['brand']}' AND id!='$id' LIMIT 4");
            while($r=mysqli_fetch_assoc($related)){ ?>
                <div class="col-md-3 mb-3">
                    <div class="card h-100 shadow-sm">
                        <img src="uploads/products/<?= $r['main_image'] ?>" class="card-img-top" style="height:180px; object-fit:cover;">
                        <div class="card-body d-flex flex-column">
                            <h6 class="card-title"><?= $r['product_name'] ?></h6>
                            <div class="mt-auto d-flex justify-content-between">
                                <a href="product-details.php?id=<?= $r['id'] ?>" class="btn btn-primary btn-sm">View</a>
                                <a href="checkout.php?product_id=<?= $r['id'] ?>" class="btn btn-success btn-sm">Buy Now</a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>

</div>

<?php include 'includes/footer.php'; ?>
